#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models
from django.utils import timezone

from gm_types.gaia import (
    AGILE_TAG_TYPE,
    AGILE_TAG_CREATE_TYPE,
    AGILE_TAG_STYLE,
    AGILE_TAG_RECOMMEND_TYPE,
    AGILE_TAG_ATTRIBUTE,
    AGILE_TAG_HERA_RECOMMEND_TAB_TYPE,
)

from api.models.tag import Tag as OldTag


class BaseModel(models.Model):

    class Meta:
        abstract = True

    is_online = models.BooleanField(verbose_name=u"是否有效", default=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class AgileTag(BaseModel):
    class Meta:
        verbose_name = u'新标签'
        db_table = 'api_agile_tag'

    name = models.CharField(verbose_name=u'新标签名字', max_length=128, null=False, unique=True, default='')
    description = models.TextField(verbose_name=u'描述', default='')
    create_tag_type = models.CharField(
        verbose_name=u"标签创建类型", max_length=3, choices=AGILE_TAG_CREATE_TYPE, default=AGILE_TAG_CREATE_TYPE.OPERATOR)
    style = models.CharField(
        verbose_name=u"标签样式", max_length=3, choices=AGILE_TAG_STYLE, default=AGILE_TAG_STYLE.UNDEFINED)
    attribute = models.CharField(verbose_name=u"标签属性", max_length=3, choices=AGILE_TAG_ATTRIBUTE, default=AGILE_TAG_ATTRIBUTE.NULL)
    topic_recommend_sort = models.IntegerField(verbose_name=u'帖子推荐排序', default=9999)


class AgileTagType(BaseModel):
    class Meta:
        verbose_name = u'新标签类型(可多选)'
        db_table = 'api_agile_tag_type'

    agile_tag_id = models.IntegerField(verbose_name=u'新标签', db_index=True)
    agile_tag_type = models.CharField(
        verbose_name=u"标签类型", max_length=3, choices=AGILE_TAG_TYPE, default=AGILE_TAG_TYPE.UNDEFINED)


class AgileTagRecommendType(BaseModel):
    class Meta:
        verbose_name = u'新标签推荐类型(可多选)'
        db_table = 'api_agile_tag_recommend_type'

    agile_tag_id = models.IntegerField(verbose_name=u'新标签', db_index=True)
    agile_tag_type = models.CharField(
        verbose_name=u"标签推荐类型", max_length=3, choices=AGILE_TAG_RECOMMEND_TYPE)


class AgileTagMapping(BaseModel):
    class Meta:
        verbose_name = u'新标签与老标签映射关系(可多选)'
        db_table = 'api_agile_tag_mapping'

    agile_tag_id = models.IntegerField(verbose_name=u'新标签', db_index=True)
    old_tag_id = models.IntegerField(verbose_name=u'老标签', db_index=True)


class AgileTagHeraRecommend(BaseModel):
    class Meta:
        verbose_name = u'hera后台推荐新标签'
        db_table = 'api_agile_tag_hera_recommend'
        unique_together = ('agile_recommend_type', 'agile_tab_type')

    agile_recommend_type = models.CharField(verbose_name=u"内容范围(标签推荐类型)", max_length=11, choices=AGILE_TAG_RECOMMEND_TYPE)
    agile_tab_type = models.CharField(verbose_name=u"类型(TAB按钮类型)", max_length=11, choices=AGILE_TAG_HERA_RECOMMEND_TAB_TYPE)
    agile_tag_sort_ids = models.TextField(verbose_name=u'配置的新标签有序列表，json字符串', default="")
