#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json

from django.db.models import Q

from agile.models.agile_tag import AgileTagHeraRecommend


class AgileTagHeraRecommendService(object):
    model = AgileTagHeraRecommend
    _base_query = Q(is_online=True)

    @classmethod
    def get_hera_recommend_agile_tag_ids(cls, recommend_type, tab_type, start_num=0, count=15):
        """
        获取推荐标签
        :param recommend_type:
        :param tab_type:
        :param start_num:
        :param count:
        :return:
        """
        filter_query = cls._base_query & Q(
            agile_recommend_type=recommend_type,
            agile_tab_type=tab_type
        )
        agile_tag_ids = []
        _agile_tag_sort_ids = cls.model.objects.filter(filter_query).values_list("agile_tag_sort_ids", flat=True).last()
        if _agile_tag_sort_ids:
            agile_tag_ids = json.loads(_agile_tag_sort_ids)[start_num: start_num + count]
        return agile_tag_ids
