# -*- coding: utf-8 -*-

from django.db import models

from gm_types.gaia import REQUEST_SOURCE

from rpc.api_control import request_source


class RequestSourceManager(models.Manager):
    """马甲包配置项"""

    def get_queryset(self):
        req_source = request_source.__dict__.get('req_source')
        if req_source:
            return super(RequestSourceManager, self).get_queryset().filter(
                req_source=req_source
            )
        else:
            return super(RequestSourceManager, self).get_queryset().filter()


class RequestSourceModel(models.Model):

    objects = RequestSourceManager()

    class Meta:
        abstract = True

    req_source = models.CharField(u'请求来源', max_length=32, choices=REQUEST_SOURCE.choices, default=REQUEST_SOURCE.GEMGMEI)
