# coding=utf-8

import datetime

from django.core.management import BaseCommand
from api.models import Diary, Service
from api.models.types import TAG_TYPE


class Command(BaseCommand):

    def handle(self, *args, **kwargs):

        start_time = datetime.datetime(2015, 11, 24)
        diaries = Diary.objects.filter(created_time__gt=start_time)
        for diary in diaries:
            tags = diary.tags.all()
            if (diary.service and
                not tags.filter(tag_type__in=[TAG_TYPE.ITEM_WIKI,
                                              TAG_TYPE.BODY_PART_SUB_ITEM])):
                service = diary.service
                service_tags = service.tags.all()
                for tag in service_tags.filter(
                        tag_type__in=[TAG_TYPE.ITEM_WIKI,
                                      TAG_TYPE.BODY_PART_SUB_ITEM]):
                    diary.tags.add(tag)
                    break
