# coding=utf-8

import csv

from django.core.management import BaseCommand

from answer.models import Answer, Question, User


class Question_Data(object):
    def __init__(self, line):
        self.id = line[0]
        self.title = line[1]
        self.content = line[2]
        self.images = line[3]
        self.user_id = line[4]


class Answer_Data(object):
    def __init__(self, line):
        self.id = line[0]
        self.question_id = line[1]
        self.content = line[2]
        self.images = line[3]
        self.vote_num = line[4]
        self.user_id = line[5]


class Command(BaseCommand):
    def handle(self, *args, **kwargs):
        questions = []
        answers = []

        reader = csv.reader(file('Sheet1.csv', 'rb'))
        for line in reader:
            q = Question_Data(line)
            try:
                u = User.objects.get(id=q.user_id)
                qs = Question.objects.create(user_id=q.user_id, title=q.title,
                                             id=q.id, content=q.content)
            except:
                print 'error: question_id: ' + str(q.id)

        reader = csv.reader(file('Sheet2.csv', 'rb'))
        for line in reader:
            a = Answer_Data(line)
            try:
                u = User.objects.get(id=a.user_id)
                answer = Answer.objects.create(id=a.id, user_id=a.user_id,
                                               content=a.content, like_num=a.vote_num,
                                               question_id=a.question_id)
            except:
                print 'error: answer_id: ' + str(a.id)
