# coding=utf-8
from __future__ import print_function, unicode_literals, absolute_import

from django.core.management import BaseCommand
from rpc.tool.random_tool import random_str
from api.models import UserExtra, Person
from api.models.types import PLATFORM_CHANNEL


class Command(BaseCommand):
    """
    anonymous user should be created only ONCE
    """
    def handle(self, *args, **options):
        phone = '88888888881'
        anonymous_user = UserExtra.create_user(phone, '', random_str(32))
        anonymous_user.last_name = '游客'
        anonymous_user.save()

        Person.objects.create(phone=phone, user=anonymous_user, platform=PLATFORM_CHANNEL.UNKNOWN)
        print ('Anonymous user id is %d' % (anonymous_user.id,))

