#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2019/7/4

from datetime import datetime
from django.core.management import BaseCommand
from api.models import Notification

user_ids = [31244300, 31236098, 31358993, 31358995, 31358996, 31358998, 31359000, 31359002, 31359003, 31359004, 31359005, 31359006, 31236150, 31236152, 31236157, 31236160, 31039555, 31039558, 31039561, 31236109, 31039568, 31236189, 31358994, 31358997, 31490178, 31358999, 31359001, 21577896, 31236124, 31228079, 31228086, 31228094, 2449600, 31228115, 31228129, 31228134, 31228141, 31178991, 31178993, 31228150, 31228158, 31236139, 31228167, 31228174, 31228190, 31228198, 31236145, 31228211, 31228219, 31228224, 31228232, 31228243, 31228249, 31228255, 31228260, 31228266, 29548908, 31228274, 31228285, 31228292, 31228299, 31039663, 31526981, 31228330, 31228338, 31228344, 31241631, 31228352, 31228362, 29925838, 31228375, 31228383, 31228401, 31228410, 31228417, 31354966, 28107273, 31228435, 31354975, 31121982, 30767705, 31354980, 29622883, 29762154, 30573165, 31490688, 31106232, 705714, 29344540, 24814456, 31425428, 30679971, 31228070, 29156331, 30638250, 29672485, 30508072, 29672494, 29672508, 29672512, 29672518, 29672524, 26076239, 29672531, 29672535, 29672543, 29672545, 29672549, 29672552, 29672579, 29672584, 29672590, 29123734, 29672601, 29672606, 29672612, 29672614, 29672617, 29672621, 29672627, 29672628, 31106229, 31106233, 29672636, 31228106, 29672639, 22791362, 29672644, 31106256, 29672667, 29672669, 30467294, 29672680, 29672684, 29672686, 29672689, 29672692, 29672700, 29672706, 18982153, 31228121, 29263151, 21775670, 25052481, 29853238, 30467402, 20432205, 23635285, 28878175, 24577376, 30344566, 31226826, 31369492, 30467522, 30557649, 21300690, 29943292, 30205439, 30205447, 30205452, 30205458, 31236105, 31446421, 30959158, 30410298, 351160, 2295393, 31226815, 31228183, 28968599, 31426201, 30205601, 31226823, 30205612, 29427378, 30205642, 31426256, 30205652, 30557931, 29427447, 31228205, 29423239, 29542188, 31442820, 29672528, 31236118, 31442843, 30468004, 29755315, 25159606, 30476218, 30205898, 30205922, 30205928, 30205607, 30205935, 30205937, 23783410, 29878396, 30697608, 20547787, 31228280, 31434976, 28567798, 31254804, 26429724, 27953455, 31254838, 31236132, 30984513, 29362533, 31228307, 29786519, 31228316, 31228322, 30616032, 29346306, 28895747, 31443477, 31328841, 24201807, 31025843, 22391505, 31228369, 30468853, 31419131, 31419135, 31419142, 31419144, 31419146, 31419148, 31419151, 31419154, 31419158, 31443754, 31181646, 31181647, 31181648, 31181649, 31181650, 31181651, 31181653, 31181654, 31181655, 31181656, 31181657, 31181658, 26749790, 31228393, 26495911, 28213754, 31228425, 28257383, 24947855, 31228441, 25439418, 23751902, 30117092, 21630183, 30117100, 30117105, 2436340, 30117111, 30117113, 30747933, 19090748, 31239562, 30141839, 2187286, 24767904, 31239585, 31182264, 31182265, 31182267, 31182268, 31182269, 31182270, 20114880, 31182273, 31182274, 31182277, 31182278, 31182279, 31182280, 31182281, 31182296, 31182299, 31182300, 31182301, 26750434, 24030696, 31526399, 31436291, 29339159, 31436379, 23957111, 1904277, 30887646, 31182572, 31182573, 31182574, 31182575, 31182576, 31182577, 31411954, 31182579, 31182580, 31182581, 31182582, 31182583, 31182584, 31297303, 31469372, 31371075, 29814639, 28938142, 27627427, 19443631, 20254679, 29724636, 26565969, 31109102, 28831732, 31109126, 31109127, 31109129, 31109130, 31109136, 31354900, 31436844, 31256634, 31354948, 31354949, 31354950, 31354951, 31354952, 31354954, 31354955, 31354956, 31354957, 31354958, 31354959, 31354961, 31354962, 31354963, 31354964, 31354965, 31354967, 31354968, 31354973, 31354974, 31354976, 31354977, 31354978, 31354979, 31354981, 31354982, 31354983, 31354984, 25563252, 31445133, 31379613, 29806767, 31207638, 30675176, 19280113, 24654070, 27095291, 31445278, 26538274, 23908644, 22647095, 31420757, 29547931, 30290351, 30208489, 29643353, 25443770, 31052405, 31182271, 31182272, 26268306, 29700890, 29672630, 21189316, 31224604, 31224605, 31224606, 30495566, 463708, 31380356, 29021094, 31208363, 20173755, 31224778, 31224779, 19805010, 31421459, 29119508, 28849268, 25490550, 30495868, 30495869, 30542542, 29430922, 29777431, 29430926, 29430932, 300183, 29430942, 29430963, 29430972, 29430977, 29430984, 29430989, 29430999, 29431003, 29431008, 29431014, 22426866, 29431047, 23090446, 29431055, 29431058, 29431064, 29431066, 29431071, 29431076, 29431089, 29431095, 29431099, 29431103, 29431109, 31225159, 31225160, 29431118, 31241560, 29431130, 31241568, 29431140, 29431145, 31241580, 29431149, 31241584, 29431153, 29431162, 31118717, 29431171, 25326980, 29431178, 31241611, 29431180, 29431187, 31241621, 29431191, 29431192, 29431194, 31241637, 31241640, 31241657, 31438333, 29431303, 29431308, 29431310, 29431315, 29431316, 29431321, 29431326, 29431327, 29431330, 29431334, 29431337, 29431342, 29431349, 29431353, 29431357, 31176255, 31235971, 29423211, 29423215, 29423217, 31236052, 29423223, 29423225, 29423226, 29423235, 29423244, 30791348, 31358582, 21993160, 27473618, 22206182, 31438586, 28653870, 28735259, 24966115, 22222747, 29939638, 29792190, 19404775, 31202983, 28588017, 28752001, 31029380, 22034582, 29010086, 21321929, 29014225, 31178981, 23124310, 28714048, 29645198, 293264, 25860501, 30308779, 24967614, 24746455, 30710234, 20855279, 28253952, 28555809, 29694498, 24795734, 31439477, 29555364, 29317801, 31038130, 31251129, 29874878, 30495862, 31431369, 31480532, 31193830, 31431420, 20840236, 31283987, 31226689, 31440694, 28834658, 31422953, 29080445, 29672598, 23428022, 31226814, 31226816, 31226817, 31226828, 29851474, 29719556, 23559214, 30202998, 29719689, 29719690, 30260370, 22430923, 30760161, 31236063, 31354960, 29236461, 28499843, 31234616, 29672676, 31079771, 29900162, 31439429, 25836968, 28483063, 28892676, 30965280, 30180619, 31358558, 31358559, 31358560, 31358561, 31358562, 31358563, 31358564, 31358565, 31358567, 31358568, 31358569, 31358570, 31358571, 31358572, 31358573, 31358574, 31358575, 31358576, 31358577, 31358578, 31358579, 31358580, 31358581, 31358583, 31358584, 31358585, 31358586, 31358587, 31358588, 31358589, 31358590, 31358591, 31358592, 31182578, 31358690, 31358691, 31358692, 31358713, 31358714, 31358715, 31358716, 31358717, 31358718, 31358719, 31358720, 31358721, 31358722, 31358723, 31358724, 31358725, 31358726, 31358727, 786204, 31358801, 31358802, 31358803, 31358804, 31358805, 31358806, 31358807, 31236069, 31235947, 31235953, 31235959, 31235965, 2449283, 31235983, 28753811, 26337174, 31235998, 31235999, 31236004, 31236005, 31236011, 31236021, 31236027, 31236033, 31236040, 31236087, 31236046, 31236058, 31236093, 31236080, 31244285]


class Command(BaseCommand):
    def handle(self, *args, **options):
        start_datetime = datetime.strptime("2019-07-04 14:55:00", "%Y-%m-%d %H:%M:%S")
        end_datetime = datetime.strptime("2019-07-04 15:05:00", "%Y-%m-%d %H:%M:%S")

        for user_id in user_ids:
            wait_delete = []
            ids_set = set()
            notifs = Notification.objects.filter(use_id=user_id, create_time__range=(start_datetime, end_datetime))
            for notif in notifs:
                hash_code = hash(notif.title + notif.url + notif.content)
                if hash_code not in ids_set:
                    ids_set.add(hash_code)
                else:
                    wait_delete.append(notif.id)

            Notification.objects.filter(id__in=wait_delete).delete()

