# coding=utf-8

from api.models import Special, Slide
from django.core.management import BaseCommand
from gm_types.gaia import SLIDE_POSITION, SLIDE_TYPE


class Command(BaseCommand):
    def handle(self, *args, **options):
        specials = Special.objects.filter(is_servicehome=True).filter(type=Special.SPECIAL_TYPE.SERVICE)
        for special in specials:
            service = {
                'is_online': special.is_online,
                'effect_time': special.start_time,
                'end_time': special.end_time,
                'slide_img': special.image,
                'title': special.title,
                'special': special,
                'slide_type': SLIDE_TYPE.SPECIAL,
                'position': SLIDE_POSITION.SERVICE_HOME,
            }
            slide = Slide.objects.create(**service)
            print 'special: {}  slide{}'.format(special.id, slide.id)
        print '********************DONE********************'
