#!/usr/bin/env python
# -*- coding: utf-8 -*-
'''
__title__ = '删除重复的美购图片、美购推荐美购'
__author__ = 'zhouyang@igengmei.com'
__mtime__ = '18/10/25'
'''

from django.db.models import Max, Count
from django.db import transaction
from django.core.management import BaseCommand
from api.models.service import ServiceRelatedRecommendService, ServiceRegisterRelatedRecommendService, \
    ImageRelatedService, ImageRelatedServiceRegister


class Command(BaseCommand):
    """
    python manage.py delete_multi_service_recommand
    """

    def handle(self, *args, **options):
        irsr_ids = ImageRelatedServiceRegister.objects.values('serviceregister_id', 'image_url')\
            .annotate(count=Count('id')).annotate(max_id=Max('id'))\
            .values_list('max_id', flat=True).filter(count__gt=1)
        print(len(irsr_ids))
        ImageRelatedServiceRegister.objects.filter(id__in=list(irsr_ids)).delete()
        irs_ids = ImageRelatedService.objects.values('service_id', 'image_url')\
            .annotate(count=Count('id')).annotate(max_id=Max('id'))\
            .values_list('max_id', flat=True).filter(count__gt=1)
        print(len(irs_ids))
        ImageRelatedService.objects.filter(id__in=list(irs_ids)).delete()
        srrs_ids = ServiceRelatedRecommendService.objects.values('service_id', 'recommend_service_id')\
            .annotate(count=Count('id')).annotate(max_id=Max('id'))\
            .values_list('max_id', flat=True).filter(count__gt=1)
        print(len(srrs_ids))
        ServiceRelatedRecommendService.objects.filter(id__in=list(srrs_ids)).delete()
        srrrs_ids = ServiceRegisterRelatedRecommendService.objects.values('serviceregister_id', 'recommend_service_id')\
            .annotate(count=Count('id')).annotate(max_id=Max('id'))\
            .values_list('max_id', flat=True).filter(count__gt=1)
        print(len(srrrs_ids))
        ServiceRegisterRelatedRecommendService.objects.filter(id__in=list(srrrs_ids)).delete()
        print('Done')