#!/usr/bin/env python
# coding=utf-8
import json

from django.core.management import BaseCommand
from django.db import transaction

from gm_types.doctor import DOCTOR_INFO_STATUS

from api.models import DoctorEditRecord, Doctor


class Command(BaseCommand):

    def handle(self, *args, **options):

        # 有问题的医生提交
        doctor_id = 'zhuguanfeng'
        record = DoctorEditRecord.objects.filter(doctor_id=doctor_id).last()
        real_d_id = json.loads(record.content)['id']
        if real_d_id == doctor_id:
            print u'{}没问题，不用处理'.format(doctor_id)
            return
        error_doctor = record.doctor
        real_doctor = Doctor.objects.get(id=real_d_id)
        with transaction.atomic():
            error_doctor.status = DOCTOR_INFO_STATUS.CHECKED
            error_doctor.save()
            record.doctor = real_doctor
            record.status = DOCTOR_INFO_STATUS.APPLY_EDIT
            record.save()
            real_doctor.status = DOCTOR_INFO_STATUS.APPLY_EDIT
            real_doctor.save()
