# coding:utf-8

"""下载oneimage数据"""

import time

from django.core.management.base import BaseCommand
from django.db.models import Q

from utils.execel import ExcelWriter
from api.models.beauty_topic import MotherWord, BeautyPhoto, MotherwordPhotoRelated



class Command(BaseCommand):

    help = '下载oneimage数据'

    def handle(self, *args, **options):

        print('------ starting -----')
        start_time = time.time()
        print("start at: ", start_time)

        excel = ExcelWriter("oneimage.xlsx")

        excel.create_sheet("api_motherword")
        mws = MotherWord.objects.filter(is_online=True).all()
        rows = []
        for mw in mws:
            rows.append([mw.id, mw.name, mw.gender, mw.content_ad, int(mw.is_online)])
        excel.write_rows(1, rows)
        excel.save()

        excel.create_sheet("api_beautyphoto")
        bps = BeautyPhoto.objects.filter(is_online=True).all()
        rows = []
        for bp in bps:
            rows.append([bp.id, bp.role_name, bp.url.replace("https://heras.igengmei.com/", ''), bp.gender, int(bp.is_online)])
        excel.write_rows(1, rows)
        excel.save()

        excel.create_sheet("api_motherwordphotorelated")
        mprs = MotherwordPhotoRelated.objects.all()
        rows = []
        for mpr in mprs:
            rows.append([mpr.id, mpr.beautyphoto_id, mpr.motherword_id])
        excel.write_rows(1, rows)
        excel.save()

        end_time = time.time()
        print("end at: ", end_time)
        print('total use {} s.'.format(end_time - start_time))
        print('Done!')
