#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2019/2/16

import tablib
import traceback
from django.core.management import BaseCommand
from facialactivity.models import ActivityUserImage
from api.models.user import UserExtraWechatInfo


class Command(BaseCommand):
    """
    python manage.py export_new_spring_activity
    """

    def handle(self, *args, **options):

        dt_acu = tablib.Dataset()
        dt_acu.headers = [u'用户ID', u'图片', u'点击数', u'等级', u'微信昵称']

        acues = ActivityUserImage.objects.filter(
            is_online=True, is_deleted=False,
            is_vest=False, level__in=[4, 5, 6, 7]
        )

        for acu in acues:
            try:
                u = UserExtraWechatInfo.objects.get(user_id=acu.user_id)
                click_nums = acu.fake_exceed_nums + acu.real_click_nums
                row_acu = [
                    acu.user_id,
                    acu.image_url + '-w',
                    click_nums,
                    acu.level,
                    u.wechat_nickname
                ]
                dt_acu.append(row_acu)
            except Exception as e:
                print e.message
                traceback.print_exc()
                continue
        open(u'newspring_user.xlsx', 'wb').write(dt_acu.xlsx)

        print (u'Done')

