# coding=utf-8
import tablib
from django.core.management import BaseCommand

from api.models import SpecialSeckillService


class Command(BaseCommand):
    """
    python manage.py export_service_sekill_data
    """

    def handle(self, *args, **options):
        file_log = open('dachuservice/7.txt', 'r')
        dt1 = tablib.Dataset()
        dt1.headers = [u'美购ID', u'专题ID', u'ID', u'秒杀价', u'抵扣', u'预付款', u'更美价']
        lines = file_log.readlines(100000)
        for line in lines:
            try:
                service_id = int(line)
                sekill_service = SpecialSeckillService.objects.filter(service_id=service_id)
                for item in sekill_service:
                    row = []
                    row.append(item.service.id)
                    row.append(item.special.id)
                    row.append(item.id)
                    row.append(item.seckill_price)
                    row.append(item.commission)
                    row.append(item.pre_payment_price)
                    row.append(item.service.gengmei_price)
                    message = str(item.service.id) + u',' + str(item.special.id) + u',' + str(item.id) + u',' + \
                              str(item.seckill_price) + u',' + str(item.commission) + u',' + \
                              str(item.pre_payment_price) + str(item.service.gengmei_price) + u'\n'
                    print message
                    dt1.append(row)
            except Exception as e:
                print e.message
                continue
        open(u'美购秒杀数据.xlsx', 'wb').write(dt1.xlsx)
        print (u"导出成功!!")
        file_log.close()
