# coding=utf-8
from django.core.management import BaseCommand
from api.models import PreOperationImage
from api.models import TopicImage


def _prefix(string, middle_or_end):
    pos = string.find(middle_or_end)
    if pos != -1:
        return string[:pos]
    else:
        return string


class Command(BaseCommand):

    def handle(self, *args, **options):
        pre_images = PreOperationImage.objects.filter(image_url__contains='-')
        for i in pre_images:
            i.delete()
        topic_images = TopicImage.objects.filter(image_url__contains='-')
        for i in topic_images:
            if i.image_type == 0:
                i.image_type = 1
            i.image_url = _prefix(i.image_url, '-')
            i.save()
