# coding=utf-8

from django.core.management import BaseCommand
from django.db import transaction

from api.models.bd_transfer import BDTransferClueTag


class Command(BaseCommand):
    def handle(self, *args, **options):
        tag_name_set = {
            u"价格敏感", u'预算多', u'决策困难', u'喜好医美', u'长恢复期敏感', u'要求效果自然', u'手术恐惧', u'抗拒沟通', u'喜好沟通'
        }
        with transaction.atomic():
            for tag_name in tag_name_set:
                BDTransferClueTag.objects.get_or_create(name=tag_name, is_online=True)
