#coding:utf-8

import xlrd
from django.core.management import BaseCommand
from gm_types.gaia import MULTITOPIC_REVIEW_TYPE, MULTITOPIC_REVIEW_STATUS
from injection.data_sync.views import write_to_es


from api.models.multitopic import MultiTopicReview


class Command(BaseCommand):
    def handle(self, *args, **options):
        data = xlrd.open_workbook('树洞id.xlsx')
        table = data.sheet_by_index(0)
        topic_ids = []
        for i in range(table.nrows):
            row = table.row_values(i)
            topic_id = int(row[1])
            m, create = MultiTopicReview.objects.get_or_create(content_type=MULTITOPIC_REVIEW_TYPE.PROBLEM, content_id=topic_id)
            m.status = MULTITOPIC_REVIEW_STATUS.PASS
            m.save()

            topic_ids.append(topic_id)

        write_to_es('topic', pk_list=topic_ids, configuration=None)

