#!/usr/bin/env python
# coding=utf-8

import datetime
from django.core.management import BaseCommand
from api.models.service import ServiceLock, SKULock, LockList


class Command(BaseCommand):

    def handle(self, *args, **options):
        locklists = LockList.objects.filter(end_time__gte=datetime.datetime.now())
        for locklist in locklists.iterator():
            sls = ServiceLock.objects.filter(locklist=locklist)
            for sl in sls.iterator():
                for si_id in sl.service.items.values_list('id', flat=True):
                    sku, _ = SKULock.objects.get_or_create(locklist=locklist, serviceitem_id=si_id)
                    print 'skuid={}'.format(si_id)
        print 'Done!'

