# coding=utf-8
import datetime
from django.core.management.base import NoArgsCommand
from api.models import Order
from api.models import CashBackOrder
from api.models import ORDER_STATUS
from api.models import NEW_CASH_BACK_STATUS
from django.db import transaction

order_list = [
        
        ]


class Command(NoArgsCommand):
    def handle(self, *args, **options):
        for one_order in order_list:
            print "order %s ............" % one_order
            order = Order.objects.get(pk=one_order)
            refund_order = None
            try:
                cashback_order = CashBackOrder.objects.get(order=order)
            except CashBackOrder.DoesNotExist:
                pass
            with transaction.atomic():
                assert order.status in (
                    ORDER_STATUS.USED,
                    ORDER_STATUS.SETTLING,
                    ORDER_STATUS.SETTLED,
                )
                assert cashback_order.status != NEW_CASH_BACK_STATUS.SUCCESS
                print "cashback_order.status, before: %s, after: %s" % (cashback_order.status, NEW_CASH_BACK_STATUS.SUCCESS)
                if cashback_order is not None:
                    now = datetime.datetime.now()
                    cashback_order.status = NEW_CASH_BACK_STATUS.SUCCESS
                    cashback_order.cashbacked_at = now
                    cashback_order.save()
