# -*- coding: utf-8 -*-

import json

from django.utils import timezone
from django.db.models import Q
from django.conf import settings
from django.core.management import BaseCommand

from api.models import Doctor
from api.models import Service
from api.models import Hospital
from api.models import Order
from talos.models.diary import Diary
from talos.models.tractate import SoftArticle


class Command(BaseCommand):

    def handle(self, *args, **kwargs):

        # 上海的机构
        # hospital_ids = list(Hospital.objects.using(settings.SLAVE_DB_NAME).filter(
        #     city_id="shanghai").values_list("id", flat=True))
        hospital_ids = ["shhhuamei", "shymylmrmzb852", "69d437149bf211e6b5a000163e000d0b", "shnsyy"]

        # 上海的医生
        # doctor_ids = list(Doctor.objects.using(settings.SLAVE_DB_NAME).filter(
        #     hospital__city_id="shanghai").values_list("id", flat=True))
        doctor_ids = list(Doctor.objects.using(settings.SLAVE_DB_NAME).filter(
            hospital_id__in=hospital_ids).values_list("id", flat=True))

        # 上海的美购
        service_ids = list(Service.objects.using(settings.SLAVE_DB_NAME).filter(
            doctor_id__in=doctor_ids).values_list("id", flat=True))

        # 上海的订单
        order_ids = list(Order.objects.using(settings.SLAVE_DB_NAME).filter(
            service__in=service_ids).values_list("id", flat=True))

        ##########################################
        ################# 日记本操作 ###############
        ##########################################

        diary_ids = list(Diary.objects.filter(
            Q(is_online=True) & (Q(order_id__in=order_ids) |
                                 Q(service_id__in=service_ids) |
                                 Q(doctor_id__in=doctor_ids) |
                                 Q(hospital_id__in=hospital_ids))
        ).values_list("id", flat=True))

        # 写日志
        with open("offline_diary_ids.txt", "a+") as f:
            f.write(json.dumps(diary_ids))

        # 一次下线 200 条日记
        cnt = 200
        while diary_ids:
            d_ids = diary_ids[:cnt]
            Diary.objects.filter(id__in=d_ids).update(
                is_online=False,
                last_modified=timezone.now()
            )
            diary_ids = diary_ids[cnt:]

        ##########################################
        ################# 医生贴操作 ###############
        ##########################################

        # doctor_post_ids = list(SoftArticle.objects.filter(
        #     Q(is_online=True) & Q(doctor_id__in=doctor_ids)
        # ).values_list("id", flat=True))

        # # 写日志
        # with open("offline_doctor_post_ids.txt", "a+") as f:
        #     f.write(json.dumps(doctor_post_ids))

        # # 一次下线 200 条
        # while doctor_post_ids:
        #     s_ids = doctor_post_ids[:cnt]
        #     SoftArticle.objects.filter(id__in=s_ids).update(
        #         is_online=False,
        #         last_modified=timezone.now()
        #     )
        #     doctor_post_ids = doctor_post_ids[cnt:]
