# coding=utf-8
# description:导入产品提供的美购service和tag关联的数据,数据来自excel
# author:gao ming
# update time:2019.05.07

import xlrd
from django.core.management import BaseCommand
from api.models import ServiceTag
from gm_types.gaia import TAG_TYPE




def add_service_tag(file):
	try:
		data = xlrd.open_workbook(file.decode('utf-8'))
		sheet=data.sheets()[0]
	except Exception as e:
		print str(e)
		print "file not exists!"

	for index in range(1,sheet.nrows):
		row=sheet.row_values(index)
		if row:
			try:
				service_id,tag_id=int(row[2]),int(row[3])
				ServiceTag.objects.get_or_create(
                    service_id=service_id,
                    tag_id=tag_id
                )
				print "导入:service_id:{0},tag_id:{1}成功!".format(service_id,tag_id)
			except Exception as e:
				print "wrong action:service_id:{0},tag_id:{1}".format(service_id,tag_id)
				print str(e)



class Command(BaseCommand):
    """
    python manage.py relation_190507_service_with_tag
    """
    def handle(self, *args, **options):
        add_service_tag("tag.xlsx")
        print 'Complete!'