#!/usr/bin/env python
# coding=utf-8
from django.core.management import BaseCommand

from api.models import AgreementDoctor


class Command(BaseCommand):
    """
    NOTE:
        保证 AgreementDoctor中记录的唯一性
    """

    def handle(self, *args, **kwargs):
        """
        steps:
        """
        agds = AgreementDoctor.objects.all()
        record = []
        for agd in agds:
            item = '{}_{}'.format(agd.agreement_id, agd.doctor_id)
            if item in record:
                print('delete data: id is {}, agreement_id is {}, doctor_id is {}'.format(
                    agd.id, agd.agreement_id, agd.doctor_id
                ))
                agd.delete()
            else:
                record.append(item)
