# coding=utf-8
import re

from django.core.management import BaseCommand
from openpyxl import load_workbook

from api.models import Service
import tablib


class Command(BaseCommand):
    """
    批量修改美购的详细信息 python manage.py replace_service_detail
    """

    def handle(self, *args, **options):
        #         desc = u"""【如何返现】
        # 步骤一.手术后，在APP内开帖分享治疗过程。
        # 1）需分享术前清晰照2张
        # 2）更新术后当天、次日、一周、两周……恢复后的文字描述和照片，不少于（返现金额/50 +1）次日志分享，每次清晰照片不少于2张，文字描述不少于20字。
        # 步骤二.发帖满3个月后在「我---我的订单---已消费」里找到此订单，进入订单页，申请返现；所长会审核日记是否合格，若合格所长会将（更美价*5%）元现金返还至用户支付账户。
        # 本活动的最终解释权归更美及项目医院所有。"""
        desc = u"【如何返现】\r\n" \
               u"步骤一.手术后，在APP内开帖分享治疗过程。\r\n" \
               u"1）添加相对应的美购项目\r\n" \
               u"2）需分享术前清晰照2张\r\n" \
               u"3）更新术后当天、次日、一周、两周……恢复后的文字描述和照片，不少于（返现金额/50 +1）次日志分享，每次清晰照片不少于2张，文字描述不少于20字。\r\n" \
               u"步骤二.发帖满1个月后在「我---我的订单---已消费」里找到此订单，进入订单页，申请返现；所长会审核日记是否合格，若合格所长会将（更美价*5%）元现金返还至用户支付账户。\r\n" \
               u"本平台可返现金额不高于用户实际支付金额。当用户实际支付金额低于返现金额时，按照实际支付金额进行返现。\r\n" \
               u"在不违反现行法律、法规要求前提下，本活动规则由更美APP及项目医院进行说明。\r\n" \
               u"注：所有参与返现的日记本和帖子，上传照片时禁止打马赛克，隆胸、吸脂等涉及隐私部位的手术，仅可遮挡隐私部位。此外，图片须满足基本的美观度和可参考性。\r\n" \
               u"更美返现给用户，则视为用户同意独家授权本组内容的肖像权给予更美平台，相关发帖内容用户不得自行删除。"
        desc1 = u"【如何返现】\r" \
                u"步骤一.手术后，在APP内开帖分享治疗过程。\n" \
                u"1）添加相对应的美购项目\n" \
                u"2）需分享术前清晰照2张\n" \
                u"3）更新术后当天、次日、一周、两周……恢复后的文字描述和照片，不少于（返现金额/50 +1）次日志分享，每次清晰照片不少于2张，文字描述不少于20字。\n" \
                u"步骤二.发帖满1个月后在「我---我的订单---已消费」里找到此订单，进入订单页，申请返现；所长会审核日记是否合格，若合格所长会将（更美价*5%）元现金返还至用户支付账户。\n" \
                u"本平台可返现金额不高于用户实际支付金额。当用户实际支付金额低于返现金额时，按照实际支付金额进行返现。\n" \
                u"在不违反现行法律、法规要求前提下，本活动规则由更美APP及项目医院进行说明。\n" \
                u"注：所有参与返现的日记本和帖子，上传照片时禁止打马赛克，隆胸、吸脂等涉及隐私部位的手术，仅可遮挡隐私部位。此外，图片须满足基本的美观度和可参考性。\n" \
                u"更美返现给用户，则视为用户同意独家授权本组内容的肖像权给予更美平台，相关发帖内容用户不得自行删除。"
        desc2 = u"""【如何返现】
步骤一.手术后，在APP内开帖分享治疗过程。
1）添加相对应的美购项目
2）需分享术前清晰照2张
3）更新术后当天、次日、一周、两周……恢复后的文字描述和照片，不少于（返现金额/50 +1）次日志分享，每次清晰照片不少于2张，文字描述不少于20字。
步骤二.发帖满1个月后在「我---我的订单---已消费」里找到此订单，进入订单页，申请返现；所长会审核日记是否合格，若合格所长会将（更美价*5%）元现金返还至用户支付账户。
本平台可返现金额不高于用户实际支付金额。当用户实际支付金额低于返现金额时，按照实际支付金额进行返现。
在不违反现行法律、法规要求前提下，本活动规则由更美APP及项目医院进行说明。
注：所有参与返现的日记本和帖子，上传照片时禁止打马赛克，隆胸、吸脂等涉及隐私部位的手术，仅可遮挡隐私部位。此外，图片须满足基本的美观度和可参考性。
更美返现给用户，则视为用户同意独家授权本组内容的肖像权给予更美平台，相关发帖内容用户不得自行删除。"""
        desc_new = u"""【返现规则】

1.订单验证后，在订单里点击“分享返现”按钮。

2.需完成任务一：订单评价为四星级以上。

3.需完成任务二：完成符合要求的日记。

4.更新术后当天，次日，一周，两周，三周或其他天数等恢复后的文字描述和照片，不少于（返现金额/50+1）次日志分享，每次分享每次清晰照片不少于5张，文字描述不少于50字。

照片要求：
  术前：至少1张，全脸正面、侧面45°、侧面90°
  术后：至少5张（包含医院环境、手术过程、术前后对比、细节照片、各种角度等和手术相关的照片）
        1）脸部项目请提供全脸照片，非脸部项目请提供术后相关部位照片
        2）照片要求无马赛克、无遮挡（私密部位，要求穿内衣（比如隆胸）和四角短裤（比如大腿吸脂）等）
        3）术后分享高清美照，不能模糊不清，美美的照片通过率更高哦~
内容要求：首篇日记文字不少于100字 ，更新日记文字不少于50字（可以写写术前准备的小心情、医院的环境、医生方案很满意、经验分享等等）。
更新的每篇日记都会由管理员审核，可自行查看日记的审核状态，不合格的需要按照要求补齐。

注意：
1）所有日记需本人真实经历，不能抄袭，如被举报查实，将取消一切福利资格；
2）一个商品购买多次，所写日记仅按一次奖励现金；
3）更美免费活动入选的免费模特，所写帖子，不属于此活动范围；
4）注射、激光等微整项目，发帖满一个月即可申请返现；手术类项目，发帖满三个月才可以申请返现。

PS：请协助医生进行美购验证哦，订单验证后才会有“分享返现”的通道。

5.完成提示篇数的日记都获得通过就可以私信“返现小助手”进行返现，若合格小助手会将（更美价*5%）元现金返还至用户支付账户。本平台可返现金额不高于用户实际支付金额。当用户实际支付金额低于返现金额时，按照实际支付金额进行返现。



特别提示：

1）更美返现给用户，则视为用户同意独家授权本组内容的肖像权给予更美平台，相关发帖内容用户不得自行删除。

2）在不违反现行法律、法规要求前提下，本活动规则由更美APP及项目医院进行说明。"""
        wb = load_workbook(filename='service_data.xlsx')
        sheetnames = wb.get_sheet_names()
        ws = wb.get_sheet_by_name(sheetnames[0])
        list_value = []
        for rx in range(1, ws.get_highest_row() + 1):
            value = ws.cell(row=rx, column=2).value
            print value
            list_value.append(value)

        parttern = re.compile(u".*【如何返现】[^【]*")
        dt1 = tablib.Dataset()
        dt1.headers = [u'id']
        list_result = []
        services = Service.objects.filter()
        for item in services:
            print item.id
            parttern_find = parttern.findall(item.detail_description)
            if len(parttern_find) > 0 and item.id in list_value:
                old_value = item.detail_description
                item.detail_description = item.detail_description.replace(parttern_find[0], desc_new)
                item.save()
                row = [item.id]
                list_result.append(row)

        dt1.extend(list_result)
        # , item.detail_description.replace(parttern_find[0], desc_new)

        open(u'/data/export_files/service_data_replace.xlsx', 'wb').write(dt1.xlsx)
