#!/usr/bin/env python
# encoding=utf-8

from django.core.management import BaseCommand
from django.db import transaction
from api.models import Notification


class Command(BaseCommand):
    def handle(self, *args, **options):
        noti_audit = open('noti_audit.txt', 'a')
        noti_error = open('noti_error.txt', 'a')
        notis = Notification.objects.filter(url__contains=".gmei.com")
        for noti in notis.iterator():
            try:
                with transaction.atomic():
                    noti.url = noti.url.replace('.gmei.com', '.igengmei.com')
                    noti.save()
                    print noti.id
                    noti_audit.write(u'%s\n' % noti.id)
            except Exception as e:
                print str(noti.id) + u':' + e.message
                noti_error.write(str(noti.id) + u':' + e.message)
                continue

        if noti_audit:
            noti_audit.close()
        if noti_error:
            noti_error.close()

        print u'DONE!'

