# coding=utf-8
from django.core.management import BaseCommand
from django.db import transaction
from gm_types.gaia import SERVICE_REVIEW_STATUS

from api.models import ServiceRegister, ServiceReviewRecord


class Command(BaseCommand):
    """
    处理一批因为医生上传详情过长,无法审核的美购
    python manage.py set_service_review_status
    """

    def handle(self, *args, **options):
        list_serviceregister = [33535, 32821, 31844, 31762]
        for item in list_serviceregister:
            try:
                with transaction.atomic():
                    serviceregister = ServiceRegister.objects.get(pk=int(item))
                    serviceregister.photo_details = u''
                    serviceregister.review_status = SERVICE_REVIEW_STATUS.TURN_DOWN
                    serviceregister.save()
                    review_record = ServiceReviewRecord.objects.filter(serviceregister__id=serviceregister.id)
                    if review_record.count() == 1:
                        review_record[0].now_review_status = SERVICE_REVIEW_STATUS.TURN_DOWN
                        review_record[0].save()
                    print serviceregister.id
            except Exception as e:
                print e.message
                continue
        print u'Done'
