#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2019/8/20

from api.models import Order, CashBackOrder
from gm_types.gaia import CASH_BACK_STATUS
from django.core.management import BaseCommand


class Command(BaseCommand):
    """
    python manage.py sync_cash_back_status --order_id "231231,3124123123,312312"
    """

    def add_arguments(self, parser):
        parser.add_argument('--order_id', help='order_id')

    def handle(self, *args, **options):
        order_ids = options.get('order_id', "").split(",")
        for order_id in order_ids:
            cashback = CashBackOrder.objects.get(order_id=order_id)
            order = Order.objects.get(id=order_id)

            print("order_id: ", order_id,
                  "cashback_id: ", cashback.id,
                  "cashback status: ", cashback.status,
                  "order status: ", order.cash_back_status)
            if cashback.status != int(order.cash_back_status):
                order.cash_back_status = CASH_BACK_STATUS.WAIT
                order.save()
            else:
                continue
        print("done!")