#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.core.management import BaseCommand
from api.models import SpecialItem


class Command(BaseCommand):

    def handle(self, *args, **kwargs):
        count = 0
        print("BEGIN")
        spi = SpecialItem.objects.filter(special__is_new_special=True, doctorseckillapply__isnull=False)
        print("total counts: %d" % spi.count())
        for obj in spi:
            price_info = obj.get_price_info()
            active_price = int(price_info.get('gengmei_price', 0))
            pre_payment_price = int(price_info.get('pre_payment_price', 0))
            if active_price < pre_payment_price:
                print(
                        "special_id: %d, floor_id:%d, active_price: %d, pre_payment_price: %d" %(
                    obj.special_id, obj.floor_id, active_price, pre_payment_price)
                )
                obj.update_or_create_price_info()
                count += 1
        print("END")
        print("共处理了:{}".format(count))
