# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models
from django.utils import timezone

from gm_upload import ImgUrlField, IMG_TYPE
from gm_types.gaia import (
    YOUNGDOCTOR_CASE_TYPE,
    YOUNGDOCTOR_APPLY_TYPE,
)

from api.models.doctor import Doctor
from rpc.tool.dict_mixin import to_dict


# ACTIVITY_PARTICIPATE_REASON = Enumeration([
#    ('0', 'OK', u'可以参加'),
#    ('1', 'CLOSED', u'已结束'),
#    ('2', 'NOT_STARTED', u'尚未开始'),
#    ('3', 'PARTICIPATE_LIMIT', u'已经参加过'),
#    ('4', 'NOT_ENOUGH_POINTS', u'没有足够美分'),
# ])

class YoungDoctorApplicationForm(models.Model):
    class Meta:
        verbose_name = u'青年医生报名表'
        db_table = 'api_youngdoctorform'
        app_label = 'api'

    phone = models.CharField(
        max_length=20, verbose_name="手机号", unique=True, null=True)
    doctor_type = models.IntegerField(default=YOUNGDOCTOR_APPLY_TYPE.NOT_DOCTOR, verbose_name=u'医生类型')
    created_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)


class YoungDoctorCase(models.Model):
    class Meta:
        verbose_name = u'青年医生参赛案例'
        db_table = 'api_youngdoctorcase'
        app_label = 'api'

    doctor = models.ForeignKey(Doctor, null=True, blank=True, default=None, related_name='youngdoctor_case')
    doctor_name = models.CharField(
        max_length=20, verbose_name="医生名", db_index=True, null=True)
    case_type = models.IntegerField(
        choices=YOUNGDOCTOR_CASE_TYPE, default=YOUNGDOCTOR_CASE_TYPE.FACE, verbose_name=u'案例类型'
    )
    preoperartion_front_image = ImgUrlField(img_type=IMG_TYPE.DIARY, max_length=128, verbose_name=u'正面术前照图片地址')
    preoperartion_side_image = ImgUrlField(img_type=IMG_TYPE.DIARY, max_length=128, verbose_name=u'侧面术前照图片地址')
    postoperartion_front_image = ImgUrlField(img_type=IMG_TYPE.DIARY, max_length=128, verbose_name=u'正面术后照图片地址')
    postoperartion_side_image = ImgUrlField(img_type=IMG_TYPE.DIARY, max_length=128, verbose_name=u'侧面术后照图片地址')
    description = models.TextField(max_length=2000, verbose_name=u'详细描述')
    is_online = models.BooleanField(default=True, verbose_name=u'上线')
    created_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    last_modified_time = models.DateTimeField(verbose_name=u'最后更新时间', default=timezone.now)

    def to_dict(self):
        result = to_dict(self,
                         excludes=[
                             'is_online', 'created_time', 'last_modified_time',
                         ])
        return result


class YoungDoctorVote(models.Model):
    class Meta:
        verbose_name = u'青年医生投票'
        db_table = 'api_youngdoctorvote'
        app_label = 'api'

    case = models.ForeignKey(YoungDoctorCase, null=False, verbose_name=u'案例')
    vote_num = models.IntegerField(default=0, verbose_name=u'票数')
    real_vote = models.IntegerField(default=0, verbose_name=u'真实票数')
    last_modify_time = models.DateTimeField(auto_now=True, verbose_name=u'最近一次修改时间')
