#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2019/6/4

from django.db import models
from gm_upload import IMG_TYPE
from gm_upload import ImgUrlField
from gm_types.gaia import USER_GENDER


class MotherWord(models.Model):
    class Meta:
        verbose_name = u'母词表'
        db_table = 'api_motherword'
    name = models.CharField(verbose_name=u'母词命名', max_length=128)
    gender = models.SmallIntegerField(verbose_name=u'性别', choices=USER_GENDER, default=USER_GENDER.MALE)
    content_ad = models.TextField(verbose_name=u'内容文案')
    is_online = models.BooleanField(u'是否上线', default=True)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)


class BeautyPhoto(models.Model):
    class Meta:
        verbose_name = u'美图表'
        db_table = 'api_beautyphoto'

    role_name = models.CharField(verbose_name=u'角色姓名', max_length=128)
    url = ImgUrlField(img_type=IMG_TYPE.NOWATERMARK, max_length=300, verbose_name=u'图片地址')
    gender = models.SmallIntegerField(verbose_name=u'性别', choices=USER_GENDER, default=USER_GENDER.MALE)
    is_online = models.BooleanField(u'是否上线', default=True)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)


class MotherwordPhotoRelated(models.Model):
    class Meta:
        verbose_name = u'美图母词关联'
        db_table = 'api_motherwordphotorelated'

    beautyphoto = models.ForeignKey(BeautyPhoto, related_name="motherwords")
    motherword = models.ForeignKey(MotherWord)