# -*- coding: utf-8 -*-
from django.db import models
from api.models.base_model import BaseModel


class BusinessKPIData(BaseModel):
    """
    商务KPI数据管理
    """
    class Meta:
        verbose_name = '商务KPI数据管理'
        verbose_name_plural = '商务KPI数据管理'
        db_table = 'api_business_kpi_data'
        app_label = 'api'

    advertisement_group = models.CharField(verbose_name=u'商务组', max_length=100)
    advertisement_consume_kpi = models.FloatField(verbose_name=u'广告消耗KPI')
    usadvertisement_top_up_kpi = models.FloatField(verbose_name=u'广告充值KPI')
    operator = models.IntegerField(verbose_name=u'操作人ID')
    kpi_date = models.DateField(verbose_name=u'kpi时间 年月')
