#! /usr/bin/env python
# -*- coding: utf-8 -*-

from django.db import models
from gm_types.gaia import COLLEGE_LEVEL

from area import City


class College(models.Model):
    class Meta:
        verbose_name = u'大学管理'
        verbose_name_plural = verbose_name
        db_table = 'api_college'
        app_label = 'api'

    name = models.CharField(u'大学名称', max_length=64, unique=True)
    level = models.SmallIntegerField(u'大学层次', choices=COLLEGE_LEVEL,default=COLLEGE_LEVEL.JUNIOR)
    city = models.ForeignKey(City, verbose_name=u'所在城市', related_name='college')
    is_online = models.BooleanField(u'是否上下线', default=True)
    is_recommend = models.BooleanField(u'是否推荐', default=False)
