# coding: utf-8

from django.db.models import Model
from django.db.models import IntegerField, DateTimeField, ForeignKey, BooleanField

from api.models.area import City


class DiarySpreadFit(Model):
    class Meta:
        verbose_name = u'首页日记本按地域设置分布'
        app_label = 'api'

    city = ForeignKey(City, verbose_name=u'城市')
    commoncity = IntegerField(u'同城市日记本个数', default=0)
    bescity = IntegerField(u'临近地域日记本个数', default=0)
    is_online = BooleanField(u"是否下线", default=True)
    create_time = DateTimeField(auto_now_add=True)

