# coding=utf-8
from __future__ import unicode_literals

from django.db import models


class DoctorIntelligence(models.Model):
    """
        医生资质相关备份信息
        notice：目前不会主动去政府网站上匹配更新
    """

    class Meta:
        verbose_name = u'医生资质'
        verbose_name_plural = u'医生资质'
        db_table = 'api_doctor_intelligence'
        app_label = 'api'

    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True, null=True)  # 保留为以后更新用
    doctor_name = models.CharField(max_length=100, verbose_name=u'医生名')
    province = models.CharField(max_length=4, verbose_name=u'省份')  # 前端实际传到是对应到省份ID，所以目前会存对应ID
    hospital_name = models.CharField(max_length=100, verbose_name=u'医院名')
    sex = models.CharField(max_length=2, verbose_name=u'性别')
    level = models.CharField(max_length=100, verbose_name=u'医师级别')
    pro_class = models.CharField(max_length=100, verbose_name=u'执业类别')
    pro_cert_no = models.CharField(max_length=100, verbose_name=u'执业证书编号')
    pro_location = models.CharField(max_length=100, verbose_name=u'执业地点')
    pro_scope = models.CharField(max_length=100, verbose_name=u'执业范围')
    cert_grant_org = models.CharField(max_length=100, verbose_name=u'发证（批准）机关')

    def data(self):
        return {
            'doctor_name': self.doctor_name,
            'sex': self.sex,
            'level': self.level,
            'pro_class': self.pro_class,
            'pro_cert_no': self.pro_cert_no,
            'pro_location': self.pro_location,
            'pro_scope': self.pro_scope,
            'cert_grant_org': self.cert_grant_org,
        }
