# -*- coding: utf-8 -*-

from django.db import models

from gm_types.gaia import (
    FACIAL_FEATUREA,
    HEIDONG_DIMENSION
)


class HeiDongDimensionImage(models.Model):
    class Meta:
        verbose_name = u'维度图片配置'
        db_table = 'api_heidongdimensionimage'

    dimension = models.IntegerField(verbose_name=u'维度', choices=FACIAL_FEATUREA, default=FACIAL_FEATUREA.CONTOUR)
    img_url = models.CharField(max_length=256, verbose_name='图片地址')
    is_online = models.BooleanField(u'是否上线', default=True)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)


class HeiDongDimension(models.Model):
    class Meta:
        verbose_name = u'维度配置'
        db_table = 'api_heidongdimension'

    dimension = models.IntegerField(verbose_name=u'维度', choices=HEIDONG_DIMENSION, default=HEIDONG_DIMENSION.ATTRACTION)
    facial_type = models.IntegerField(verbose_name=u'部位', choices=FACIAL_FEATUREA, default=FACIAL_FEATUREA.CONTOUR)
    img_url = models.CharField(max_length=256, verbose_name='图片地址')
    out_content = models.CharField(max_length=256, verbose_name='部位外显文案')
    score = models.IntegerField(verbose_name=u"权重")
    is_online = models.BooleanField(u'是否上线', default=True)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)


class HeiDongDimensionDetail(models.Model):
    class Meta:
        verbose_name = "二级维度配置"
        db_table = 'api_heidongdimensiondetail'

    dimension = models.IntegerField(verbose_name=u'维度', choices=HEIDONG_DIMENSION, default=HEIDONG_DIMENSION.ATTRACTION)
    classification = models.CharField(verbose_name=u"部位具体类型", max_length=64)
    facial_type = models.IntegerField(verbose_name=u"部位",choices=FACIAL_FEATUREA, default=FACIAL_FEATUREA.CONTOUR)
    client = models.BooleanField(null=False, default=True, verbose_name='客户端展示')
    xcx = models.BooleanField(null=False, default=True, verbose_name='小程序展示')
    score = models.IntegerField(verbose_name=u"分值")
    polymer_id = models.CharField(verbose_name=u"聚合页id", max_length=32)
    analysis = models.CharField(verbose_name=u"分析文案", max_length=256)
    choice_button_words = models.CharField(verbose_name=u"社区按钮文字", max_length=64)
    service_button_words = models.CharField(verbose_name=u"文美购按钮文字", max_length=64)
    is_online = models.BooleanField(null=False, default=True, verbose_name='是否上线')
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
