# -*- coding: utf-8 -*-
import json
from django.db import models

from gm_types.gaia import USER_GENDER


class SkinResult(models.Model):

    class Meta:
        verbose_name = u'测肤结果'
        db_table = 'api_skin_result'

    '''
    u 'acne': [],
    u 'acne_desc': u '无',
    u 'acne_severity': 0.0,
    u 'blackhead_number': 0,
    u 'blackhead_severity': u '无',
    u 'cheek_oil_shine': 0.246,
    u 'chin_oil_shine': 0.196,
    u 'coarseness': u '蛋壳',
    u 'create_dt': u '2019-08-19 07:09:44.657113 +0000',
    u 'dark_circle': {
        u 'pigmental': 0.124,
        u 'severity': 0.208,
        u 'structural': 0.119,
        u 'vascular': 0.21
    },
    u 'diag_uid': 1064848,
    u 'error_code': 2,
    u 'error_msg': u 'likely_blur',
    u 'gender': u 'female',
    u 'oil_level': u '干性',
    u 'overall_advice': [u '你的肌肤比较干燥，现阶段护理要点如下：\n• 需要加强保湿哦，可以考虑滋润度高一些的乳霜产品\n• 黑眼圈以血管型为主，除了健康作息外，还可以使用促进眼周循环的眼霜\n• 要坚持防晒哦，不仅能防晒黑，还能防晒老哈\n'],
    u 'pore_severity': u '细致',
    u 'retcode': 0,
    u 'retmsg': u '操作成功。',
    u 'short_acne_advice': u '恭喜你，没有痘痘的困扰，你是这个世界上最幸运的宝宝(*ﾟ▽ﾟ*)！',
    u 'short_blackhead_advice': u '此次照片清晰度不足，黑头毛孔检测结果仅供参考，建议拿稳手机擦拭镜头，再拍一次哦',
    u 'short_coarseness_advice': u '皮肤看起来挺光滑哒，不过还是有提升空间的哈╯▽╰ 平时做好补水保湿，使用温和的酸类产品促进角质代谢，可以让皮肤看起来更加有光泽感~但注意不要太过频繁贴敷面膜哦，以免引起肌肤水合皮炎。',
    u 'short_dark_circle_advice': u '你有轻度的黑眼圈问题，以血管型为主。使用含有咖啡因、维生素K等成分的眼霜，能促进血液循环，对于淡化血管型黑眼圈有一定帮助~But！更重要的还是调整生活习惯,不要再熬夜修仙啦！',
    u 'short_oil_level_advice': u '皮肤看起来比较干燥，该注意加强保湿啦(\xb4・ω・`) 除了使用滋润度比较高的护肤品之外，还可以考虑多增加细胞中必需脂肪酸的含量。这些脂肪酸可以从鱼油、种子和坚果中获取~',
    u 'skin_age': 16,
    u 'skin_color_advice': u '你的肤色看起来非常健康，色调是介于冷调和暖调中间的中性色调∪▽∪ 如果有美白提亮的需求，可以在皮肤耐受的前提下，使用一些美白抗氧化类护肤品，并且严格防晒。另外，做好基础保湿，增加角质层水分含量，也可以让肌肤显得通透，起到提亮的效果~挑选粉底液的时候，记得不要选太白的哈，贴近自己肤色的会更好哦~',
    u 'skin_color_desc': u '正常',
    u 'skin_color_level': 3,
    u 'skin_color_temperature': u '中性',
    u 'skin_radar': {
        u 'equilibrium': 8.046,
        u 'health': 9.307,
        u 'smooth': 9.348,
        u 'tolerance': 0,
        u 'uniform': 7.653,
        u 'young': 9.533
    },
    u 'total_score': 88,
    u 'transcend_percent': 0.83,
    u 'tzone_oil_shine': 0.246
    '''

    total_score = models.CharField(max_length=30, verbose_name="总分", null=False)

    # skin_radar 肌肤雷达 包含各项对皮肤状态的整理描述
    equilibrium = models.CharField(max_length=30, verbose_name="干油性", null=False)
    health = models.CharField(max_length=30, verbose_name="健康度", null=False)
    smooth = models.CharField(max_length=30, verbose_name="细腻度", null=False)
    tolerance = models.CharField(max_length=30, verbose_name="耐受性", null=False)
    uniform = models.CharField(max_length=30, verbose_name="匀净度", null=False)
    young = models.CharField(max_length=30, verbose_name="年轻度", null=False)

    gender = models.CharField(max_length=1, verbose_name='性别', choices=USER_GENDER, default=USER_GENDER.FEMALE)

    skin_age = models.CharField(max_length=30, verbose_name="皮肤年龄", null=False)
    skin_color_level = models.CharField(max_length=30, verbose_name="肤色等级", null=False)
    skin_color_desc = models.CharField(max_length=30, verbose_name="肤色描述", null=False)
    skin_color_temperature = models.CharField(max_length=30, verbose_name="肤色色温", null=False)
    oil_level = models.CharField(max_length=30, verbose_name="肤质", null=False)
    blackhead_number = models.CharField(max_length=30, verbose_name="黑头个数", null=False)
    blackhead_severity = models.CharField(max_length=30, verbose_name="黑头严重程度", null=False)
    tzone_oil_shine = models.CharField(max_length=30, verbose_name="t区出油", null=False)
    cheek_oil_shine = models.CharField(max_length=30, verbose_name="脸颊出油", null=False)
    chin_oil_shine = models.CharField(max_length=30, verbose_name="下巴出油", null=False)
    pore_severity = models.CharField(max_length=30, verbose_name="毛孔严重程度", null=False)
    coarseness = models.CharField(max_length=30, verbose_name="粗糙程度", null=False)

    # dark_circle 各项黑眼圈问题
    pigmental = models.CharField(max_length=30, verbose_name="色素", null=False)
    vascular = models.CharField(max_length=30, verbose_name="血管", null=False)
    structural = models.CharField(max_length=30, verbose_name="结构", null=False)
    severity = models.CharField(max_length=30, verbose_name="总分", null=False)

    # 痘痘
    acne_json = models.TextField(verbose_name="痘痘，为一个列表，包含每个痘痘的位置和程度", null=False)
    acne_severity = models.CharField(max_length=30, verbose_name="痘痘的总和严重程度", null=False)
    acne_desc = models.CharField(max_length=30, verbose_name="痘痘严重程度描述", null=False)

    short_oil_level_advice = models.TextField(verbose_name="针对肤质类型的简短建议", null=False)
    short_coarseness_advice = models.TextField(verbose_name="针对光滑度的简短建议", null=False)
    short_blackhead_advice = models.TextField(verbose_name="针对黑头的简短建议", null=False)
    short_acne_advice = models.TextField(verbose_name="针对痘痘的简短建议", null=False)
    short_dark_circle_advice = models.TextField(verbose_name="针对黑眼圈的简短建议", null=False)

    image_url = models.CharField(max_length=80, verbose_name='测肤图片')
    device_id = models.CharField(max_length=100, verbose_name=u'设备ID', db_index=True)
    user_id = models.IntegerField(verbose_name=u"用户id", db_index=True, default=0)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    client_cache = models.BooleanField(u'客户端是否缓存', default=True)

    @property
    def skin_radar(self):
        return {
            'equilibrium': self.equilibrium,
            'health': self.health,
            'smooth': self.smooth,
            'tolerance': self.tolerance,
            'uniform': self.uniform,
            'young': self.young,
        }

    @property
    def dark_circle(self):
        return {
            'pigmental': self.pigmental,
            'vascular': self.vascular,
            'structural': self.structural,
            'severity': self.severity,
        }

    @property
    def acne(self):
        return json.loads(self.acne_json)
