#! /usr/bin/env python
# -*- coding: utf-8 -*-

from django.db import models
from gm_types.gaia import SCAN_TYPE


class ScanRecord(models.Model):
    class Meta:
        verbose_name = u'扫脸或者测肤结果'
        db_table = 'api_scan_record'

    user_id = models.IntegerField(verbose_name=u"用户id", db_index=True)
    device_id = models.CharField(verbose_name=u"原始照片地址", max_length=128, db_index=True)
    scan_type = models.IntegerField(verbose_name='记录类型', choices=SCAN_TYPE.choices)
    data = models.TextField(verbose_name='用户操作记录')
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    client_cache = models.BooleanField(u'客户端是否缓存', default=True)
