# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import, print_function

import traceback
import logging

from django.db import models

from api.models.product import ProductWiki
from api.models.brand import BrandWiki
from api.models.item import NewItemWiki
from api.models.collect import CollectWiki
import datetime


class Wiki_Keyword(models.Model):
    class Meta:
        verbose_name = u'新百科tab'
        db_table = 'al_wiki_cityvisit_topten_d'
        unique_together = (("city_id", "rank"),)

    wiki_id = models.IntegerField(verbose_name=u'百科ID')
    city_id = models.CharField(verbose_name=u'城市id', max_length=64)
    wiki_type = models.IntegerField(verbose_name=u"百科类型")
    visit_num = models.IntegerField(verbose_name=u"点击次数")
    rank = models.IntegerField(verbose_name=u'排名')
    visit_time = models.CharField(verbose_name=u"时间",max_length=20)

    def get_wiki_id_name(self):

        try:

            now = datetime.datetime.now()
            yes_time = now - datetime.timedelta(days=1)
            yes_time_str = yes_time.strftime('%Y%m%d')

            if self.wiki_type == 0 and self.visit_time == yes_time_str:
                query_results = NewItemWiki.objects.filter(
                    id=self.wiki_id, is_online=True, description__isnull=False).exclude(description='').first()

            elif self.wiki_type == 1 and self.visit_time == yes_time_str:
                query_results = CollectWiki.objects.filter(
                    id=self.wiki_id, is_online=True, description__isnull=False).exclude(description='').first()

            elif self.wiki_type == 2 and self.visit_time == yes_time_str:
                query_results = BrandWiki.objects.filter(
                    id=self.wiki_id, is_online=True, description__isnull=False).exclude(description='').first()

            elif self.wiki_type == 3 and self.visit_time == yes_time_str:
                query_results = ProductWiki.objects.filter(
                    id=self.wiki_id, is_online=True, description__isnull=False).exclude(description='').first()

            else:
                query_results = None

            item_wiki_id_name = query_results and query_results.name or None

            logging.info("related_product_id_list:%s" % item_wiki_id_name)

            return item_wiki_id_name

        except:

            logging.error("get_item_related_product_id:%s" % traceback.format_exc())

            return ''

    def get_wiki_id_is_online(self):

        try:

            if self.wiki_type == 0:
                query_results = NewItemWiki.objects.filter(id=self.wiki_id)

            if self.wiki_type == 1:
                query_results = CollectWiki.objects.filter(id=self.wiki_id)

            if self.wiki_type == 2:
                query_results = BrandWiki.objects.filter(id=self.wiki_id)

            if self.wiki_type == 3:
                query_results = ProductWiki.objects.filter(id=self.wiki_id)

            for item in query_results:

                item_wiki_id_is_online = item.is_online

            logging.info("related_product_id_list:%s" % item_wiki_id_is_online)

            return item_wiki_id_is_online

        except:

            logging.error("get_item_related_product_id:%s" % traceback.format_exc())

            return ''
