# -*- coding:utf-8 -*-
'''
术后关怀, 表中数据由数据组通过埋点途径写入
'''

import datetime

from django.db import models

from api.models import base_model

class PushClickUser(base_model.BaseModel):
    '''
    点击了术后关怀推送的用户
    '''
    class Meta:
        verbose_name = '术后关怀点击推送用户记录表'
        app_label = 'api'
        db_table = 'maidian_push_click_user'

    user_id = models.IntegerField(verbose_name='用户id', null=False)
    day = models.DateField(verbose_name='日期')

    @classmethod
    def get_user_ids(cls, day=None):
        if not day:
            day = datetime.datetime.now().date()
        user_ids = list(cls.objects.filter(day=day).values_list('user_id', flat=True).distinct())
        return user_ids
