#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__: vv
# Date: 2019/8/30

from django.db import models
from gm_types.gaia import USERCALL_STATUS, USERCALL_EVENT_TYPE


class ProtectPhone(models.Model):
    class Meta:
        verbose_name = u'用户手机号隐私保护'
        db_table = 'api_protectphone'
        app_label = 'api'

    favor = models.CharField('喜好', max_length=128)
    city_id = models.CharField('城市', max_length=64)
    operator = models.CharField("呼叫人员", max_length=32, db_index=True)
    user_id = models.CharField('用户id', db_index=True, max_length=64)
    wechat = models.CharField('微信号', max_length=64, null=True)
    is_get_wechat = models.BooleanField('是否获取微信', default=False)
    bind_time = models.DateTimeField("绑定时间", null=True)
    unbind_time = models.DateTimeField("解绑时间", null=True)
    create_time = models.DateTimeField("创建时间", auto_now_add=True, null=True)
    update_time = models.DateTimeField('更新时间', auto_now=True, null=True)
    subscriptionid = models.CharField('绑定id', null=True, max_length=128)
    call_status = models.IntegerField('呼叫状态', default=USERCALL_STATUS.NOT_HANDLE, choices=USERCALL_STATUS)
    event_id = models.CharField('事件ID', max_length=64, null=True, db_index=True)
    event_type = models.IntegerField('事件类型', default=USERCALL_EVENT_TYPE.ORDER_CHECK, choices=USERCALL_EVENT_TYPE, null=True, db_index=True)
    is_online = models.BooleanField(verbose_name=u"是否有效", default=True)


class ProtectPhoneLog(models.Model):
    class Meta:
        verbose_name = u'绑定记录表(AXB)'
        db_table = "api_protectphonelog"
        app_label = "api"
    a_user_id = models.CharField(u'A用户ID', max_length=128)
    b_user_id = models.CharField(u'B用户ID', max_length=128)
    x_phone_num = models.CharField(u'绑定中间号', max_length=128)
    subscriptionid = models.CharField('绑定id', null=True, max_length=128)
    is_delete = models.BooleanField('是否删除', default=False)
    create_time = models.DateTimeField("创建时间", auto_now_add=True, null=True)
    update_time = models.DateTimeField('更新时间', auto_now=True, null=True)
    event_type = models.IntegerField('事件类型', default=USERCALL_EVENT_TYPE.ORDER_CHECK, choices=USERCALL_EVENT_TYPE, null=True)
    protect_phone_id = models.IntegerField('隐私保护id', default=0)
