# coding=utf-8
from django.db import models

# TODO Skyler 迁移
from hippo.models.record import PhoneServiceRecord


class PhoneCallRecord(models.Model):
    class Meta:
        verbose_name = u'通话录音数据'
        db_table = 'api_phone_call_record'
        app_label = 'api'

    phone_ext = models.CharField(max_length=10, verbose_name="分机号码", null=True, blank=True, default='')
    call_id = models.CharField(
        u'服务商提供的记录唯一标识',
        max_length=100,
        default='',
        db_index=True,
        help_text=u'用于通话记录排重',
    )
    added_at = models.DateTimeField(auto_now_add=True)
