# coding: utf-8

from django.db import models
from api.models import Tag


class RecommendUserAttention(models.Model):
    class Meta:
        verbose_name = u'推荐用户关注'
        db_table = 'api_recommenduserattention'
        app_label = 'api'

    ordering = models.IntegerField(default=99, verbose_name=u"展示顺序", help_text=u"小的排在前，大的排在后")
    tag = models.ForeignKey(Tag, verbose_name=u'关联项目')
    is_online = models.BooleanField(help_text=u"是否上线", verbose_name=u"上线")
    image_url = models.CharField(max_length=300, verbose_name=u'图片')
    is_delete = models.BooleanField(default=False, help_text=u"是否删除", verbose_name=u"是否删除")
