# -*- coding: UTF-8 -*-

from django.db import models
from rpc.tool.dict_mixin import to_dict
from gm_upload import ImgUrlField, IMG_TYPE


class Share(models.Model):
    class Meta:
        app_label = 'api'

    title = models.CharField(u'微信/QQ好友标题', max_length=100)
    content = models.CharField(u'微信/QQ好友内容', max_length=300)
    moments = models.CharField(u'朋友圈', max_length=300)
    weibo = models.CharField(u'微博', max_length=300)
    image = ImgUrlField(u'图片', img_type=IMG_TYPE.SHARE, max_length=300)

    def to_dict(self):
        data = to_dict(
            self,
            fields=['title', 'content', 'moments', 'weibo', 'image'],
        )
        return data
