# coding=utf-8

from __future__ import unicode_literals, absolute_import, print_function
from django.db import models, transaction
from .types import PRIVATE_CONVERSATION_STATUS, PRIVATE_MESSAGE_PUSH_STATUS
from .service import Service
from .doctor import Doctor
from .hospital import Hospital
from django.utils import timezone


class ShortMessageSend(models.Model):
    class Meta:
        verbose_name = u'短信发送'
        verbose_name_plural = u'短信发送'
        app_label = 'api'

    content = models.CharField(max_length=75, verbose_name=u'短信内容')
    service = models.ManyToManyField(Service, verbose_name=u'关联的美购', through='ShortMessageSendService',
                                     null=True, blank=True)
    doctor = models.ManyToManyField(Doctor, verbose_name=u'关联的医生', through='ShortMessageSendDoctor',
                                    null=True, blank=True)
    hospital = models.ManyToManyField(Hospital, verbose_name=u'关联的医院', through='ShortMessageSendHospital',
                                      null=True, blank=True)
    order_status = models.CharField(max_length=100, verbose_name=u'订单的状态', null=True, blank=True)
    send_time = models.DateTimeField(verbose_name=u'发送时间', default=timezone.now)
    send_status = models.BooleanField(verbose_name=u'发送状态', default=False)
    phone_list = models.TextField(verbose_name=u'自由添加号码', default='', blank=True)


class ShortMessageSendService(models.Model):
    class Meta:
        app_label = 'api'

    service = models.ForeignKey(Service)
    shortmessagesend = models.ForeignKey(ShortMessageSend)

    def __unicode__(self):
        return "%s:%d" % (self.shortmessagesend.id, self.service.id)


class ShortMessageSendDoctor(models.Model):
    class Meta:
        app_label = 'api'

    doctor = models.ForeignKey(Doctor)
    shortmessagesend = models.ForeignKey(ShortMessageSend)

    def __unicode__(self):
        return "%s:%d" % (self.shortmessagesend.id, self.doctor.id)


class ShortMessageSendHospital(models.Model):
    class Meta:
        app_label = 'api'

    hospital = models.ForeignKey(Hospital)
    shortmessagesend = models.ForeignKey(ShortMessageSend)

    def __unicode__(self):
        return "%s:%d" % (self.shortmessagesend.id, self.hospital.id)
