# coding=utf-8

from django.db import models
from gm_types.gaia import PLATFORM_CHANNEL


class UpdatePop(models.Model):
    class Meta:
        verbose_name = u'客户端更新弹窗提示'
        db_table = 'api_update_pop'
        app_label = 'api'

    source = models.IntegerField(verbose_name='来源', choices=PLATFORM_CHANNEL, null=False)
    version = models.CharField(verbose_name='版本号', max_length=100, null=False)
    updateversion = models.CharField(verbose_name='强制更新版本号', max_length=100)
    code = models.IntegerField(verbose_name='版本code', null=False)
    content = models.TextField(verbose_name='更新内容', null=False)
    download_link = models.CharField(verbose_name='下载地址', max_length=100)
    create_time = models.DateTimeField(auto_now_add=True, verbose_name=u'添加时间')

    def get_update_info(self):
        result = {
            'source': self.source,
            'version': self.version,
            'minimum_support_version': self.updateversion if self.updateversion else '0.0.0',
            'version_code': self.code,
            'description': self.content,
            'apk': self.download_link,
            'create_time': self.create_time.strftime("%Y-%m-%d %H:%M:%S"),
        }
        return result
