# coding=utf-8
'''
date: 2019-04-28
记录用户信息变更日志
'''

from django.db import models
from django.contrib.auth.models import User
from gm_types.gaia import USER_CHANGE_LOG_TYPE, USER_CHANGE_LOG_OPERATE_TYPE


class UserChangeLog(models.Model):
    class Meta:
        verbose_name = '用户信息变更日志表'
        app_label = 'api'
        db_table = 'api_user_change_log'

    user = models.ForeignKey(User, verbose_name=u"变更日志")
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    change_type = models.SmallIntegerField(verbose_name=u"变更来源",
                                           choices=USER_CHANGE_LOG_TYPE,
                                           default=USER_CHANGE_LOG_TYPE.SYSTEM,)  # 暂不使用，以后扩展
    operate_type = models.SmallIntegerField(verbose_name=u"操作类型",
                                            choices=USER_CHANGE_LOG_OPERATE_TYPE,
                                            default=USER_CHANGE_LOG_OPERATE_TYPE.LOGIN,)  # 暂不使用，以后扩展
    comment = models.CharField(verbose_name=u"备注", max_length=128, blank=True, null=True)
