# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models
from django.db.models import ForeignKey, IntegerField, CharField, TextField
from django.db.models import BooleanField, ManyToManyField, DateTimeField
from django.db.models import OneToOneField

from gm_upload import ImgUrlField, IMG_TYPE
from gm_types.wiki import TREATMENT_TYPE, ANESTHESIA_TYPE, ACHE_LEVEL_NEW


class ItemTag(models.Model):
    class Meta:
        verbose_name = u'项目百科关联关键词'
        db_table = 'wiki_item_keywords'

    item_id = CharField(verbose_name=u'项目百科', max_length=11)
    wordrel_id = CharField(verbose_name=u"关键字", max_length=11)
    category = CharField(u'分类', max_length=5)
    is_effect = BooleanField(verbose_name=u'是否有效', default=True)


class BrandTag(models.Model):
    class Meta:
        verbose_name = u'品牌百科关联关键词'
        db_table = 'wiki_brand_keywords'

    brand_id = CharField(verbose_name=u'项目百科', max_length=11)
    wordrel_id = CharField(verbose_name=u"关键字", max_length=11)
    category = CharField(u'分类', max_length=5)
    is_effect = BooleanField(verbose_name=u'是否有效', default=True)


class ProductTag(models.Model):
    class Meta:
        verbose_name = u'药品 材料 仪器百科 关联关键词'
        db_table = 'wiki_product_keywords'

    product_id = CharField(verbose_name=u'项目百科', max_length=11)
    wordrel_id = CharField(verbose_name=u"关键字", max_length=11)
    category = CharField(u'分类', max_length=5)
    is_effect = BooleanField(verbose_name=u'是否有效', default=True)


class Wiki_wordrelsynonym(models.Model):
    class Meta:
        verbose_name = u'关键词'
        db_table = 'api_wordrelsynonym'

    wordrel_id = models.IntegerField(verbose_name='标签ID', primary_key=True)
    word = models.CharField(u'标签', max_length=48)


class WordRel_wiki(models.Model):
    class Meta:
        verbose_name = u'关键词'
        db_table = 'api_wordrel'

    id = models.IntegerField(verbose_name=u'标签ID', primary_key=True)
    keyword = models.CharField(verbose_name=u"词根", max_length=50)
    category = models.CharField(verbose_name=u"类型", max_length=50)


class Wiki_wordrelresemble(models.Model):
    class Meta:
        verbose_name = u'关键词'
        db_table = 'api_wordrelresemble'

    wordrel_id = models.IntegerField(verbose_name='标签ID', primary_key=True)
    word = models.CharField(u'标签', max_length=48)
