# coding=utf-8

from django.db import models
from gm_upload import IMG_TYPE, ImgUrlField
from gm_protocol import GmProtocol
from gm_types.gaia import ZONE_DETAIL_SORT_TYPE, ZONE_TYPE_V2

from .tag import Tag

gm_protocol = GmProtocol()


class Zone(models.Model):
    class Meta:
        app_label = 'api'
        verbose_name = u'圈子'
        db_table = 'api_zone'

    tag = models.OneToOneField(Tag, help_text=u'圈子关联的Tag', null=False)
    is_communityhome = models.BooleanField(help_text=u'是否展示于社区首页', default=False, null=False)
    home_rank = models.IntegerField(help_text=u'社区首页排序顺序', default=99999)
    circle_rank = models.IntegerField(help_text=u'圈子列表排序顺序', default=99999)
    icon_image = ImgUrlField(help_text=u'图标图片', img_type=IMG_TYPE.CIRCLEICON, max_length=400, default='')
    banner_image = ImgUrlField(help_text=u'相关圈子横幅', img_type=IMG_TYPE.CIRCLEBANNER, max_length=400, default='')
    sentence_descr = models.CharField(help_text=u'圈子一句话描述', max_length=100, default='')
    is_openrelated = models.BooleanField(help_text=u'是否打开项目百科,相关日记,相关美购', default=False)
    # 活动相关
    campaign_banner = ImgUrlField(help_text=u'活动banner图', img_type=IMG_TYPE.CAMPAIGNBANNER, max_length=400, default='',
                                  null=False)
    title = models.CharField(help_text=u'活动标题', null=False, max_length=400, default='')
    campaign_descr = models.TextField(help_text=u'活动详情', null=False, default='')
    campaign_descr_richtext = models.TextField(help_text=u'活动详情', null=False, default='')

    is_online = models.BooleanField(help_text=u'是否上线', default=False)
    created_time = models.DateTimeField(help_text=u'创建时间', auto_now_add=True)

    # added at 6.6.0
    show_diary_tab = models.BooleanField(help_text=u'展示日记本tab', default=True)
    show_topic_tab = models.BooleanField(help_text=u'展示讨论tab', default=True)
    show_service_tab = models.BooleanField(help_text=u'展示美购tab', default=False)

    default_sort_type = models.IntegerField(help_text=u'默认内容显示顺序', choices=ZONE_DETAIL_SORT_TYPE)

    topic_tab_position = models.IntegerField(help_text=u'讨论tab展示位置', default=1)
    diary_tab_position = models.IntegerField(help_text=u'日记本tab展示位置', default=2)
    service_tab_position = models.IntegerField(help_text=u'美购tab展示位置', default=999999)

    zone_type = models.IntegerField(help_text=u'圈子类型', choices=ZONE_TYPE_V2)
    # added at 6.6.0 end
    # 2017.5.17 讨论与问答合并
    show_qa_tab = models.BooleanField(help_text=u'展示问答tab', default=True)
    qa_tab_position = models.IntegerField(help_text=u'问答tab展示位置', default=3)

    def get_related_tag(self):
        '''获得相关圈子'''
        res = []
        related_zones = TagRelatedTag.objects.filter(zone=self).order_by("rank")
        for o in related_zones:
            res.append({
                "name": o.relatedzone.tag.name,
                "icon": o.relatedzone.banner_image,
                'url': gm_protocol.get_zone_detail(o.relatedzone.tag.id, o.relatedzone.tag.name.encode('utf8')),
            })
        return res

    def get_overhead_topic(self):
        '''获得置顶贴子'''
        res = []
        topics = OverHeadTopic.objects.filter(zone=self, deleted=False).order_by("rank")
        for o in topics:
            res.append({
                "title": o.title,
                "url": gm_protocol.get_topic_detail(o.topic_id),
            })
        return res

    def zone_info(self):
        return {
            'tag_id': self.tag.id,
            'zone_name': self.tag.name,
            'zone_cover': self.icon_image,
        }


class OverHeadTopic(models.Model):
    class Meta:
        app_label = 'api'
        verbose_name = u'圈子推荐贴'
        db_table = 'api_overheadtopic'

    zone = models.ForeignKey(Zone, help_text=u'圈子')
    topic_id = models.IntegerField(verbose_name=u'指定的话题', null=True, blank=True)
    title = models.CharField(help_text=u'顶贴标题', default='', max_length=400)
    rank = models.IntegerField(help_text=u'排序顺序', null=False, default=0)
    created_time = models.DateTimeField(help_text=u'创建时间', auto_now_add=True)
    deleted = models.BooleanField(help_text=u'是否已删除', default=False)


class OverHeadDiary(models.Model):
    class Meta:
        app_label = 'api'
        verbose_name = u'圈子推荐日记本'
        db_table = 'api_overheaddiary'

    zone = models.ForeignKey(Zone, help_text=u'圈子')
    diary_id = models.IntegerField(help_text=u'日记本', null=False)
    rank = models.IntegerField(help_text=u'排序顺序', null=False, default=0)
    created_time = models.DateTimeField(help_text=u'创建时间', auto_now_add=True)
    deleted = models.BooleanField(help_text=u'是否已删除', default=False)


class TagRelatedTag(models.Model):
    class Meta:
        app_label = 'api'
        verbose_name = u'项目圈子相关圈子'
        db_table = 'api_tag_related_tag'

    zone = models.ForeignKey(Zone, help_text=u'项目圈子')
    relatedzone = models.ForeignKey(Zone, help_text=u'相关Tag', related_name=u'related_zone')
    rank = models.IntegerField(help_text=u'排序顺序', default=0)
    created_time = models.DateTimeField(help_text=u'创建时间', auto_now_add=True)
