# coding=utf-8
from __future__ import unicode_literals, absolute_import, print_function

from api.models import Tag
from api.models import TAG_TYPE
from polymer.models import PolymerTag

# 临时写死数据。不展示没百科卡片的标签
tag_wiki_mapping_conf = {  # tag_id : (wiki_id, wiki_type) 这种结构么？
    7823, 6163, 5074, 4437, 3042, 2941, 2939, 2938, 2935, 2923, 2866, 2778, 2108,
    2063, 2060, 2059, 2056, 1890, 1622, 1370, 1233, 1055, 986, 933, 928, 912, 910,
    903, 901, 897, 878, 873, 872, 864, 863, 824, 822, 821, 812, 811, 810, 806,
    798, 797, 796, 789, 780, 778, 777, 775, 253, 252, 251, 246, 236, 234, 233,
    232, 200, 187, 181, 172, 153, 152, 151, 136, 135, 128, 127, 126, 125, 124,
    123, 118, 117, 116, 115, 102, 98, 92, 91, 90, 89, 88, 87, 86, 85, 22
}


def list_tags_by_polymer_ids(polymer_ids):
    """
    批量返回聚合页对应的一级，二级，三级标签
    :param polymer_ids:
    :return:
    """

    polymer_tag_relate = PolymerTag.objects.filter(polymer_id__in=polymer_ids,
                                  is_online=True).values("tag_id", "polymer_id").order_by("polymer_id")
    tag_ids = [i['tag_id'] for i in polymer_tag_relate]
    tags_info = Tag.objects.filter(
        pk__in=tag_ids,
        is_online=True,
        tag_type__in=[TAG_TYPE.BODY_PART, TAG_TYPE.BODY_PART_SUB_ITEM, TAG_TYPE.ITEM_WIKI]
    ).in_bulk(tag_ids)

    result = {}
    for item in polymer_ids:
        result[int(item)] = []

    for item in polymer_tag_relate:
        tag_id, polymer_id = int(item['tag_id']), int(item['polymer_id'])

        if tag_id in tags_info and tag_id in tag_wiki_mapping_conf:
            result[polymer_id].append({'tag_name': tags_info[tag_id].name, 'tag_id': tag_id})
    return result
