#! /usr/bin/env python
# -*- coding: utf-8 -*-
# create by oldman
# Date: 2019/7/7
import datetime
from celery import shared_task
from django.contrib.auth.models import User
from gm_types.gaia import ORDER_STATUS

from api.models import Order
from api.models import UserNewOld


@shared_task
def async_user_new_or_old():
    """
    每天增量同步新老用户的状态
    :return:
    """
    now =  datetime.datetime.now().date()
    now = datetime.datetime(now.year, now.month, now.day,0,0,0)
    async_date_start = now + datetime.timedelta(days=-1)
    new_users = User.objects.filter(userextra__create_time__gte=async_date_start, userextra__create_time__lt=now)
    for user in new_users:
        try:
            UserNewOld.objects.get_or_create(user_id=user.id)
        except Exception as e:
            continue

    orders = Order.objects.filter(pay_time__gte=async_date_start, pay_time__lt=now)
    print orders[0].id
    for order in orders:
        try:
            usernewold, _ = UserNewOld.objects.get_or_create(user_id=order.user_id)
            print usernewold.user_id
            usernewold.is_new = False
            usernewold.save()

        except Exception as e:
            print e
            continue