# coding=utf-8
from __future__ import unicode_literals, absolute_import, print_function

from datetime import datetime
from datetime import timedelta
from celery import shared_task
from rpc.tool.log_tool import logging_exception
from hippo.models.advertise import DeviceBlackList, IpBlackList 
from hippo.models.advertise import DeviceBlackClient, IpBlackClient

@shared_task
def check_device_id(start_at=None):
    """
    检查mysql中的device_id和redis中的device_id是否对应
    """
    device_client = DeviceBlackClient()
    if not start_at:
        start_at = datetime.now() - timedelta(days=1)

    for device in DeviceBlackList.objects.filter(is_redis=False, update_time__gte=start_at):
        device_id = device.device_id
        device_client.set_key(device_id, "hera")
    

@shared_task
def check_ip(start_at=None):
    """
    检查mysql中的ip和redis中的ip是否对应
    """
    ip_client = IpBlackClient()
    if not start_at:
        start_at = datetime.now() - timedelta(days=1)

    for ip_obj in IpBlackList.objects.filter(is_redis=False, update_time__gte=start_at):
        ip = ip_obj.ip
        ip_client.set_key(ip, "hera")
        
