# coding=utf-8
from rpc.context import get_rpc_remote_invoker

from api.tool.log_tool import logging_exception


def get_user_questions_count(user_id):
    try:
        r = get_rpc_remote_invoker()
        result = r['qa/question/get_user_qa_count'](user_id=user_id).unwrap()
        return result
    except:
        logging_exception()
        return 0


def get_questions_data_list_by_ids(ids):
    try:
        r = get_rpc_remote_invoker()
        result = r['qa/question/get_data_list_by_ids'](ids=ids).unwrap()
        return result
    except:
        logging_exception()
        return {}


def get_answer_list_by_ids(ids):
    try:
        r = get_rpc_remote_invoker()
        data = r['qa/answer/list_for_es'](pks=ids).unwrap()
        dct = {}
        for k, v in data.items():
            v['reply_num'] = v['comment_num']
            del v['comment_num']
            dct[int(k)] = v
        return dct

    except:
        logging_exception()
        return {}
